using System;
using System.Web.UI.WebControls;
using System.Web.UI;
using System.ComponentModel;
using System.ComponentModel.Design;
using AjaxControlToolkit;

[
    assembly: System.Web.UI.WebResource("ImageRotator.ImageRotatorBehavior.js", 
    "text/javascript")
]

namespace ImageRotator
{
    [ParseChildren(true, "ImageList")]
    [Designer(typeof(ImageRotatorDesigner))]
    [
        ClientScriptResource("ImageRotator.ImageRotatorBehavior", 
            "ImageRotator.ImageRotatorBehavior.js")
    ]
    [RequiredScript(typeof(TimerScript))]
    [TargetControlType(typeof(Image))]
    public class ImageRotatorExtender : ExtenderControlBase
    {
        [ExtenderControlProperty]
        [ClientPropertyName("rotationInterval")]
        [DefaultValue(3), DisplayName("RotationInterval(seconds))")]
        [
            DesignerSerializationVisibility(
                DesignerSerializationVisibility.Visible)
        ]
        public int RotationInterval
        {
            get { return GetPropertyValue<int>("RotationInterval", 3); }
            set { SetPropertyValue<int>("RotationInterval", value); }
        }

        private ImageUrlList _imageList;

        [ExtenderControlProperty]
        [ClientPropertyName("imageList")]
        [
            DesignerSerializationVisibility(
                DesignerSerializationVisibility.Content)
        ]
        [PersistenceMode(PersistenceMode.InnerDefaultProperty)]
        public ImageUrlList ImageList
        {
            get
            {
                if (_imageList == null)
                {
                    _imageList = GetPropertyValue<ImageUrlList>(
                        "ImageList", null);
                    if (_imageList == null)
                    {
                        _imageList = new ImageUrlList();
                        SetPropertyValue<ImageUrlList>(
                            "ImageList", _imageList);
                    }
                }
                return _imageList;
            }
        }
    }
}
